--------------------------------------------------------
-- added to make below compile
--------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
entity dff is
  port( d, clk: in std_logic;
        q : out std_logic);
end dff;
architecture behave of dff is
begin
  process
  begin
    wait until clk'event and clk = '1';
    q <= d;
  end process;
end behave;
--------------------------------------------------------
LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY shift IS    
  GENERIC ( len : INTEGER);    
  PORT( a, clk : IN std_logic;          
        b : OUT std_logic); 
END shift; 

ARCHITECTURE if_shift OF shift IS    
  COMPONENT dff        
    PORT( d, clk : IN std_logic;              
          q : OUT std_logic);    
  END COMPONENT;
    
  SIGNAL z : std_logic_vector( 1 TO (len -1) );
BEGIN    
  g1 : FOR i IN 0 TO (len -1) GENERATE        
    g2 : IF i = 0 GENERATE            
      dffx : dff PORT MAP( a, clk, z(i + 1));
    END GENERATE;
        
    g3 : IF i = (len -1) GENERATE            
      dffx : dff PORT MAP( z(i), clk, b );        
    END GENERATE;
        
    g4 : IF (i > 0) AND i < (len -1) GENERATE
      dffx : dff PORT MAP( z(i), clk, Z(i + 1) );
    END GENERATE;
    
  END GENERATE; 
END if_shift;


